/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPEstablished.java
 * Author:   Gunter Weiss
 * Contents: Actions in State Established of TCP-FSM
 * Last Changes: Gunter Weiss 23/5/97
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPEstablished
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPEstablished {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPEstablished( SegArrive home, SessionControlBlock newtcb, int j ) {

    this.parent = home;
    this.newtcb = newtcb;
    this.j = j;

    while(true) {
          if(parent.segment1.Seqnumb > newtcb.RCVNXT) {
              if(parent.segment1.Acknumb == newtcb.SNDNXT){
                if(parent.segment1.data.length >1) {
                  boolean b = new Buffert().buffert(newtcb.toclientbuffer,parent.segment1.data);
                  if(b == true) {
		            System. out.println("hier in Established");
               	    newtcb. setack.setAck();
                    if(parent.segment1.PSH == 1) newtcb.userpsh = true;
                    //("Server Daten knnten gespeichert werden");
                    TcpSegment sg8 = new TcpSegment();
                    sg8.Lpnumb = parent.segment1.Dpnumb;
                    sg8.Dpnumb = parent.segment1.Lpnumb;
                    sg8.Seqnumb = parent.segment1.Acknumb;
                    sg8.ACK = 1;
                    sg8.Hdlength = 5;
	                String s = "ESTABLISHED";
	                parent. tcppro.darfsenden.getrighttosend();
                    newtcb.SNDUNA = parent.segment1.Acknumb;
                    newtcb.SNDNXT = parent.segment1.Acknumb +1 ;
                    newtcb.RCVNXT = parent.segment1.Seqnumb + parent.segment1.data.length;
      	            newtcb.RCVWND = parent.segment1.Wsize;
       	            //("RCVWND vorletzte "+newtcb.RCVWND );
                    sg8.Acknumb = newtcb.RCVNXT;
       	            parent. tcppro.darfsenden.giverighttosend();
                    sg8.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                    sg8 = new Checksum().build(sg8);
                    parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg8,true,new Date().getTime(),true,s));
                    parent. tonet.putElement(sg8);
                    parent. fromnet.removeElementAt(0);
                    break;
                  }
                }
              }
              else {
                  TcpSegment sg9 = new TcpSegment();
                  sg9.Lpnumb = parent.segment1.Dpnumb;
                  sg9.Dpnumb = parent.segment1.Lpnumb;
                  sg9.Seqnumb = parent.segment1.Acknumb;  // newtcb.SNDNXT;
    	          sg9.ACK = 1;
                  sg9.Acknumb = newtcb.RCVNXT ;
    	          sg9.Hdlength = 5;
    	          String s = "ESTABLISHED";
                  sg9.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                  sg9 = new Checksum().build(sg9);
                  parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg9,true,new Date().getTime(),true,s));
                  parent. tonet.putElement(sg9);
                  parent. fromnet.removeElementAt(0);
                  break;
              }
          }//END of if(parent.segment1.Seqnumb > newtcb.RCVNXT)
          if((parent.segment1.data.length == 0)&(newtcb.RCVWND ==0)&(parent.segment1.Seqnumb != newtcb.RCVNXT)) {
              parent. fromnet.removeElementAt(0);
              break;
          }
          if((parent.segment1.data.length == 0)&(newtcb.RCVWND >0)&(parent.segment1.Seqnumb < newtcb.RCVNXT)) {
    		  //newtcb.SNDNXT = parent.segment1.Acknumb;
    		  //newtcb.RCVNXT = parent.segment1.Seqnumb +1;
    		  //newtcb.RCVWND = parent.segment1.Wsize;
    	      //newtcb.acktime = new Date().getTime();
              TcpSegment sg9 = new TcpSegment();
              sg9.Lpnumb = parent.segment1.Dpnumb;
              sg9.Dpnumb = parent.segment1.Lpnumb;
              sg9.Seqnumb = parent.segment1.Acknumb;// newtcb.SNDNXT;
	          sg9.ACK = 1;
              sg9.Acknumb = newtcb.RCVNXT ;
	          sg9.Hdlength = 5;
	          String s = "ESTABLISHED";
              sg9.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
              sg9 = new Checksum().build(sg9);
              parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg9,true,new Date().getTime(),true,s));
              parent. tonet.putElement(sg9);
              parent. fromnet.removeElementAt(0);
              break;
          }
          if((parent.segment1.data.length >1 )&(newtcb.RCVWND ==0)) {
              parent. fromnet.removeElementAt(0);
              break;
          }
          if(parent.segment1.Seqnumb == newtcb.RCVNXT) { // Sequencnumber O.K.
    	      if(parent.segment1.FIN ==1) { // Bestaetigung des FIN
                newtcb.TcpStatus = 5;
                TcpSegment sg9 = new TcpSegment();
                sg9.Lpnumb = parent.segment1.Dpnumb;
                sg9.Dpnumb = parent.segment1.Lpnumb;
                sg9.Seqnumb = parent.segment1.Acknumb;
    	        newtcb.RCVWND = parent.segment1.Wsize;
    	        sg9.ACK = 1;
                sg9.Acknumb = parent.segment1.Seqnumb + 1 ;
        	    parent. tcppro.darfsenden.getrighttosend();
    	        newtcb.RCVNXT = parent.segment1.Seqnumb +1;
        	    newtcb.SNDNXT = parent.segment1.Acknumb + 1; // sndnxt++ neu
    	        sg9.Hdlength = 5;
	            String s = "CLOSE_WAIT";
                sg9.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                sg9 = new Checksum().build(sg9);
                parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg9,true,new Date().getTime(),true,s));
                parent. tonet.putElement(sg9);
                parent. fromnet.removeElementAt(0);
               	parent. tcppro.darfsenden.giverighttosend();
                break;
              }
              if(parent.segment1.RST==1) {
                newtcb.partnerresp = -1;
                newtcb.TcpStatus = 0;
                newtcb. retqueue.removeAllElements();
                parent. fromnet.removeElementAt(0);
                parent. tcb.removeElementAt(j);
                parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.SYN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 0;
                parent. tcb.removeElementAt(j);
        	    parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.ACK==0){
                parent. fromnet.removeElementAt(0);
                break;
              }
              else { //else for if(parent.segment1.Seqnumb == newtcb.RCVNXT) for second checking
    		    newtcb. setack.setAck();
                if(parent.segment1.data.length == 0) {
                  newtcb.setack.setAck();
		          parent. tcppro.darfsenden.getrighttosend();
                  newtcb.SNDNXT = parent.segment1.Acknumb;
                  newtcb.RCVNXT = parent.segment1.Seqnumb +1;
                  newtcb.RCVWND = parent.segment1.Wsize;
	              newtcb.acktime = new Date().getTime();
                  parent. fromnet.removeElementAt(0);
               	  parent. tcppro.darfsenden.giverighttosend();
                  break;
                }
                if(parent.segment1.data.length == 1) { // keine Daten
	              newtcb. setack.setAck();
                  TcpSegment sgn = new TcpSegment();
                  sgn.Lpnumb = parent.segment1.Dpnumb;
                  sgn.Dpnumb = parent.segment1.Lpnumb;
                  sgn.Seqnumb = parent.segment1.Acknumb;
		          sgn.Acknumb = parent.segment1.Seqnumb + 1;
	              sgn.ACK = 1;
		          parent. tcppro.darfsenden.getrighttosend();
                  newtcb.SNDUNA = parent.segment1.Acknumb;
                  newtcb.SNDNXT = parent.segment1.Acknumb +1;
                  newtcb.RCVNXT = parent.segment1.Seqnumb + 1;
		          parent. tcppro.darfsenden.giverighttosend();
	              newtcb.RCVWND = parent.segment1.Wsize;
                  sgn.Hdlength = 5;
	              String s = "ESTABLISHED";
                  sgn.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                  sgn = new Checksum().build(sgn);
                  parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sgn,true,new Date().getTime(),true,s));
                  parent. tonet.putElement(sgn);
                  parent. fromnet.removeElementAt(0);break;
                }
                if(parent.segment1.data.length >1) {
                  boolean b = new Buffert().buffert(newtcb.toclientbuffer,parent.segment1.data);
                  if(b == true) {
		    System. out.println("hier in Established");
               	    newtcb. setack.setAck();
                    if(parent.segment1.PSH == 1) newtcb.userpsh = true;
                    //("Server Daten knnten gespeichert werden");
                    TcpSegment sg8 = new TcpSegment();
                    sg8.Lpnumb = parent.segment1.Dpnumb;
                    sg8.Dpnumb = parent.segment1.Lpnumb;
                    sg8.Seqnumb = parent.segment1.Acknumb;
                    sg8.ACK = 1;
                    sg8.Hdlength = 5;
	                String s = "ESTABLISHED";
	                parent. tcppro.darfsenden.getrighttosend();
                    newtcb.SNDUNA = parent.segment1.Acknumb;
                    newtcb.SNDNXT = parent.segment1.Acknumb +1 ;
                    newtcb.RCVNXT = parent.segment1.Seqnumb + parent.segment1.data.length;
      	            newtcb.RCVWND = parent.segment1.Wsize;
       	            //("RCVWND vorletzte "+newtcb.RCVWND );
                    sg8.Acknumb = newtcb.RCVNXT;
       	            parent. tcppro.darfsenden.giverighttosend();
                    sg8.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
                    sg8 = new Checksum().build(sg8);
                    parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg8,true,new Date().getTime(),true,s));
                    parent. tonet.putElement(sg8);
                    parent. fromnet.removeElementAt(0);
		    break;
                  }
                  else {
                    parent. fromnet.removeElementAt(0);
                    //("keine daten gespeichert Wsize ="+ newtcb.RCVWND);
                    break;
                  }
                }//END of if(parent.segment1.data.length >1)
              }//END of else
          }//END of if(parent.segment1.Seqnumb == newtcb.RCVNXT)
          //("bis hier falsches Segment");
          TcpSegment sg9 = new TcpSegment();
          sg9.Lpnumb = parent.segment1.Dpnumb;
          sg9.Dpnumb = parent.segment1.Lpnumb;
          sg9.Seqnumb =parent.segment1.Acknumb;// newtcb.SNDNXT;
          sg9.ACK = 1;
          sg9.Acknumb = newtcb.RCVNXT ;
          sg9.Hdlength = 5;
	  String s = "ESTABLISHED";
          sg9.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
          sg9 = new Checksum().build(sg9);
          parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg9,true,new Date().getTime(),true,s));
          parent. tonet.putElement(sg9);
          parent. fromnet.removeElementAt(0);
          break;
    } //END while(true)
    return newtcb;
} //END methode TCPEstablished
} //END class TCPEstablished
